//BlitzSpeech C++ Example
//Please note, you need the BlitzSpeech DLL in the output folder when the program runs.
//Currently, it is only in the "Debug" build folder, so if you try to run it with "Release",
//it will not find the DLL and fail to run. So make sure if you do test it under the release
//build, you need to copy the DLL to the release folder.

//Include and library folders are setup in the projects properties.
//The BlitzSpeech.lib is linked in the project properties too.
#include <iostream>

#include "BlitzSpeech.h"

int main()
{
	if (InitSpeech() != 0) {
		std::cerr << "Failed to initialize BlitzSpeech." << std::endl;
		return -1;
	}

	const char* text = "Hello, this is a test of the BlitzSpeech for C++.";
	if (SpeakText(text) != 0) {
		std::cerr << "Failed to speak text." << std::endl;
		CleanupSpeech();
		return -1;
	}

	WaitUntilSpeechIsDone(10000);

	CleanupSpeech();
	return 0;
}