; BlitzSpeech Blitz3D Include
; Written by Michael Denathorn 2025

; Speech flags constants
Const SPF_DEFAULT = 0
Const SPF_ASYNC = 1
Const SPF_PURGEBEFORESPEAK = 2
Const SPF_IS_FILENAME = 4
Const SPF_IS_XML = 8
Const SPF_IS_NOT_XML = 16
Const SPF_PERSIST_XML = 32
Const SPF_NLP_SPEAK_PUNC = 64
Const SPF_PARSE_SAPI = 128
Const SPF_PARSE_SSML = 256

; Available language constants
; Note: I found installing a different language and the modules 
; a bit of a pig, I tried through settings, which seemed to fail,
; then I tried through powershell, with that hanging.

; Somehow though, I managed to install French, as these voices appeared:

; Microsoft Hortense - French (France) (Language: fr-FR)
; Microsoft Julie - French (France) (Language: fr-FR)
; Microsoft Paul - French (France) (Language: fr-FR)
  
; So bare in mind, installing a language pack might silently succeed.

; Blitz3D will automatically detect them when using
; GetVoiceCount()
Const SP_LAN_ENGLISH$ = "English"
Const SP_LAN_SPANISH$ = "Spanish"
Const SP_LAN_FRENCH$ = "French"
Const SP_LAN_GERMAN$ = "German"
Const SP_LAN_ITALIAN$ = "Italian"
Const SP_LAN_PORTUGUESE$ = "Portuguese"
Const SP_LAN_DUTCH$ = "Dutch"
Const SP_LAN_RUSSIAN$ = "Russian"
Const SP_LAN_POLISH$ = "Polish"
Const SP_LAN_CHINESE$ = "Chinese"
Const SP_LAN_CHINESE_SIMPLIFIED$ = "Chinese (Simplified)"
Const SP_LAN_CHINESE_TRADITIONAL$ = "Chinese (Traditional)"
Const SP_LAN_JAPANESE$ = "Japanese"
Const SP_LAN_KOREAN$ = "Korean"
Const SP_LAN_ENGLISH_US$ = "English (United States)"
Const SP_LAN_ENGLISH_UK$ = "English (Great Britain)"
Const SP_LAN_ENGLISH_GB$ = "English (Great Britain)"
Const SP_LAN_ENGLISH_AU$ = "English (Australia)"
Const SP_LAN_ENGLISH_CA$ = "English (Canada)"
Const SP_LAN_ENGLISH_IN$ = "English (India)"
Const SP_LAN_ARABIC$ = "Arabic"
Const SP_LAN_CATALAN$ = "Catalan"
Const SP_LAN_CZECH$ = "Czech"
Const SP_LAN_DANISH$ = "Danish"
Const SP_LAN_FINNISH$ = "Finnish"
Const SP_LAN_GREEK$ = "Greek"
Const SP_LAN_HEBREW$ = "Hebrew"
Const SP_LAN_HINDI$ = "Hindi"
Const SP_LAN_HUNGARIAN$ = "Hungarian"
Const SP_LAN_NORWEGIAN$ = "Norwegian"
Const SP_LAN_SWEDISH$ = "Swedish"
Const SP_LAN_THAI$ = "Thai"
Const SP_LAN_TURKISH$ = "Turkish"

; Parameter constants for SpeakToFile
; Sample Rates (Hz)
Const SP_SAMPLE_RATE_8000 = 8000
Const SP_SAMPLE_RATE_11025 = 11025
Const SP_SAMPLE_RATE_16000 = 16000
Const SP_SAMPLE_RATE_22050 = 22050
Const SP_SAMPLE_RATE_44100 = 44100
Const SP_SAMPLE_RATE_48000 = 48000

; Bit Depths (bits per sample)
Const SP_BIT_DEPTH_8 = 8
Const SP_BIT_DEPTH_16 = 16

; Channels
Const SP_CHANNEL_MONO = 1
Const SP_CHANNEL_STEREO = 2

; Error codes for functions, just incase stuff goes
; tits up. Fully commented too.
; ----- INITIALIZATION -----
; InitSpeech() returns:
Const SP_INIT_SUCCESS = 0
Const SP_INIT_ERR_COM_FAILED = -1      ; COM initialization failed
Const SP_INIT_ERR_VOICE_FAILED = -2    ; Failed to create voice instance

; ----- BASIC SPEECH FUNCTIONS -----
; SpeakText() returns:
Const SP_SPEAK_SUCCESS = 0
Const SP_SPEAK_ERR_NOT_INIT = -1       ; Not initialized
Const SP_SPEAK_ERR_NULL_TEXT = -2      ; NULL text pointer
Const SP_SPEAK_ERR_CONV_LEN = -3       ; Failed to get wide string length
Const SP_SPEAK_ERR_CONV_ALLOC = -4     ; Failed to allocate conversion buffer
Const SP_SPEAK_ERR_CONV_FAILED = -5    ; String conversion failed
Const SP_SPEAK_ERR_FAILED = -6         ; SAPI Speak call failed

; SpeakTextFlags() returns: (same as SpeakText)
Const SP_SPEAK_FLAGS_SUCCESS = 0
Const SP_SPEAK_FLAGS_ERR_NOT_INIT = -1
Const SP_SPEAK_FLAGS_ERR_NULL_TEXT = -2
Const SP_SPEAK_FLAGS_ERR_CONV_LEN = -3
Const SP_SPEAK_FLAGS_ERR_CONV_ALLOC = -4
Const SP_SPEAK_FLAGS_ERR_CONV_FAILED = -5
Const SP_SPEAK_FLAGS_ERR_FAILED = -6

; ----- FILE FUNCTIONS -----
; SpeakFile() returns:
Const SP_FILE_SUCCESS = 0
Const SP_FILE_ERR_NOT_INIT = -1        ; Not initialized
Const SP_FILE_ERR_NULL_PATH = -2       ; NULL filepath
Const SP_FILE_ERR_CANT_OPEN = -3       ; File not found or can't open
Const SP_FILE_ERR_TOO_LARGE = -4       ; File too large (>10MB) or empty
Const SP_FILE_ERR_ENCODING = -5        ; Encoding conversion failed
Const SP_FILE_ERR_SPEAK_FAILED = -6    ; SAPI Speak call failed

; GetFileEncoding() returns:
Const SP_ENC_ANSI = 0                  ; ANSI/default code page
Const SP_ENC_UTF16_LE = 1              ; UTF-16 Little Endian
Const SP_ENC_UTF16_BE = 2              ; UTF-16 Big Endian
Const SP_ENC_UTF8 = 3                  ; UTF-8 (with or without BOM)
Const SP_ENC_ERR_NULL_PATH = -1        ; NULL filepath

; ----- CONTROL FUNCTIONS -----
; PauseSpeech() returns:
Const SP_PAUSE_SUCCESS = 0
Const SP_PAUSE_ERR_NOT_INIT = -1       ; Not initialized
Const SP_PAUSE_ERR_FAILED = -2         ; SAPI Pause call failed

; ResumeSpeech() returns:
Const SP_RESUME_SUCCESS = 0
Const SP_RESUME_ERR_NOT_INIT = -1      ; Not initialized
Const SP_RESUME_ERR_FAILED = -2        ; SAPI Resume call failed

; IsSpeaking() returns:
Const SP_IS_SPEAKING_YES = 1           ; Currently speaking
Const SP_IS_SPEAKING_NO = 0            ; Not speaking
Const SP_IS_SPEAKING_ERR = -1          ; Error/not initialized

; WaitUntilSpeechIsDone() returns:
Const SP_WAIT_SUCCESS = 0
Const SP_WAIT_ERR_NOT_INIT = -1        ; Not initialized
Const SP_WAIT_ERR_FAILED = -2          ; Wait failed or timed out

; ----- VOICE SETTINGS -----
; SetSpeechRate() returns:
Const SP_RATE_SUCCESS = 0
Const SP_RATE_ERR_NOT_INIT = -1        ; Not initialized
Const SP_RATE_ERR_FAILED = -2          ; SAPI SetRate call failed

; SetSpeechVolume() returns:
Const SP_VOLUME_SUCCESS = 0
Const SP_VOLUME_ERR_NOT_INIT = -1      ; Not initialized
Const SP_VOLUME_ERR_FAILED = -2        ; SAPI SetVolume call failed

; ----- VOICE MANAGEMENT -----
; GetVoiceCount() returns:
; Positive number = voice count
Const SP_VOICE_COUNT_ERR_NOT_INIT = -1      ; Not initialized
Const SP_VOICE_COUNT_ERR_ENUM_FAILED = -2   ; Failed to enumerate voices
Const SP_VOICE_COUNT_ERR_GET_COUNT = -3     ; Failed to get count

; GetCurrentVoice() returns:
; 0 or positive = current voice index
Const SP_GET_VOICE_ERR_NOT_INIT = -1        ; Not initialized
Const SP_GET_VOICE_ERR_NO_VOICE = -2        ; Failed to get current voice
Const SP_GET_VOICE_ERR_NO_ID = -3           ; Failed to get voice ID
Const SP_GET_VOICE_ERR_NO_ENUM = -4         ; Voice enumeration not done
Const SP_GET_VOICE_ERR_NOT_FOUND = -5       ; Current voice not in list

; SetSpeechVoice() returns:
Const SP_SET_VOICE_SUCCESS = 0
Const SP_SET_VOICE_ERR_NOT_INIT = -1        ; Not initialized
Const SP_SET_VOICE_ERR_BAD_INDEX = -2       ; Invalid voice index
Const SP_SET_VOICE_ERR_GET_TOKEN = -3       ; Failed to get voice token
Const SP_SET_VOICE_ERR_FAILED = -4          ; SAPI SetVoice call failed

; SetSpeechVoiceByName() returns:
; 0 or positive = voice index (success)
Const SP_SET_NAME_ERR_NOT_INIT = -1         ; Not initialized or NULL name
Const SP_SET_NAME_ERR_ENUM_FAILED = -2      ; Failed to enumerate voices
Const SP_SET_NAME_ERR_SET_FAILED = -3       ; Found voice but SetVoice failed
Const SP_SET_NAME_ERR_NOT_FOUND = -4        ; Voice name not found

; GetVoiceType() returns:
Const SP_VOICE_TYPE_ERROR = -1              ; Not initialized or NULL
Const SP_VOICE_TYPE_DESKTOP = 0             ; SAPI 5 platform (Traditional)
Const SP_VOICE_TYPE_ONECORE = 1             ; OneCore speech platform (Modern - Win10/11 only)

; ----- VOICE SAVING -----
; SpeakToFile() returns:
Const SP_FILE_OUT_SUCCESS = 0
Const SP_FILE_OUT_ERR_NOT_INIT = -1        ; Not initialized
Const SP_FILE_OUT_ERR_NULL_PARAM = -2      ; NULL text or filepath
Const SP_FILE_OUT_ERR_TEXT_LEN = -3        ; Failed to get text length
Const SP_FILE_OUT_ERR_TEXT_CONV = -4       ; Text conversion failed
Const SP_FILE_OUT_ERR_PATH_LEN = -5        ; Failed to get path length
Const SP_FILE_OUT_ERR_PATH_CONV = -6       ; Path conversion failed
Const SP_FILE_OUT_ERR_CREATE_STREAM = -7   ; Failed to create stream
Const SP_FILE_OUT_ERR_BIND_FILE = -8       ; Failed to bind to file
Const SP_FILE_OUT_ERR_SET_OUTPUT = -9      ; Failed to set output
Const SP_FILE_OUT_ERR_SPEAK_FAILED = -10   ; Speak call failed