
; BlitzSpeech Basic Example for Blitz3D
; Demonstrates: InitSpeech(), SpeakText(), CleanupSpeech()


; Note: Make sure BlitzSpeech.dll and BlitzSpeech.decls 
; are in the userlibs folder!

; Include the constants and error codes
Include "BlitzSpeechInclude.bb"

Print "BlitzSpeech - Basic Speech Example (Blitz3D)"

Print ""

; Initialize speech
Print "Initializing speech..."
result = InitSpeech()

If result = SP_INIT_SUCCESS Then
    Print "Speech initialized successfully!"
    Print ""
    
    ; Speak some text
    Print "Speaking: 'Hello from Blitz3D!'"
    SpeakText("Hello from Blitz3D!")
    Print ""
    
    Print "Speaking: 'This is BlitzSpeech in action.'"
    SpeakText("This is BlitzSpeech in action.")
    Print ""
    
    Print "Speaking: 'Text-to-speech is easy!'"
    SpeakText("Text-to-speech is easy!")
    Print ""
    
    ; Cleanup
    Print "Cleaning up..."
    CleanupSpeech()
    Print "Done!"
Else
    Print "ERROR: Failed to initialize speech!"
    Print "Error code: " + result
EndIf